/*********************************************************************
 *
 * Copyright:
 *	1999-2000 MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/*
 * File:		int_handlers.c
 * Purpose:		Interrupt handlers
 *
 */

#include "mcf5282.h"
#include "init.h"
#include <stdio.h>

/********************************************************************/

/* Called by asm_exception_handler */
void 
exception_handler (void *framep) 
{
	/*
	 * This is the exception handler for all defined exceptions.  Most
	 * exceptions do nothing, but some of the more important ones are
	 * handled to some extent.
	 */

	switch (MCF5200_RD_SF_FORMAT(framep))
	{
		case 4:
		case 5:
		case 6:
		case 7:
			break;
		default:
			printf("\nIllegal stack type! -- PC = %#08X\n", \
				MCF5200_SF_PC(framep));
			break;
	}

	switch (MCF5200_RD_SF_VECTOR(framep))
	{
		case 2:
			printf("Access Error -- PC = %#08X\n", MCF5200_SF_PC(framep));
			switch (MCF5200_RD_SF_FS(framep))
			{
				case 4:
					printf("Error on instruction fetch\n");
					break;
				case 8:
					printf("Error on operand write\n");
					break;
				case 9:
					printf("Attempted write to write-protected space\n");
					break;
				case 12:
					printf("Error on operand read\n");
					break;
				default:
					printf("Reserved Fault Status Encoding\n");
					break;
			}
			break;
		case 3:
			printf("Address Error -- PC = %#08X\n", MCF5200_SF_PC(framep));
			switch (MCF5200_RD_SF_FS(framep))
			{
				case 4:
					printf("Error on instruction fetch\n");
					break;
				case 8:
					printf("Error on operand write\n");
					break;
				case 9:
					printf("Attempted write to write-protected space\n");
					break;
				case 12:
					printf("Error on operand read\n");
					break;
				default:
					printf("Reserved Fault Status Encoding\n");
					break;
			}
			break;
		case 4:
			printf("Illegal instruction -- PC = %#08X\n", MCF5200_SF_PC(framep));
			break;
		case 8:
			printf("Privilege violation -- PC = %#08X\n", MCF5200_SF_PC(framep));
			break;
		case 9:
			printf("Trace Exception -- PC = %#08X\n", MCF5200_SF_PC(framep));
			break;
		case 10:
			printf("Unimplemented A-Line Instruction -- PC = %#08X\n", \
				MCF5200_SF_PC(framep));
			break;
		case 11:
			printf("Unimplemented F-Line Instruction -- PC = %#08X\n", \
				MCF5200_SF_PC(framep));
			break;
		case 12:
			printf("Debug Interrupt -- PC = %#08X\n", MCF5200_SF_PC(framep));
			break;
		case 14:
			printf("Format Error -- PC = %#08X\n", MCF5200_SF_PC(framep));
			break;
		case 15:
			printf("Unitialized Interrupt -- PC = %#08X\n", \
				MCF5200_SF_PC(framep));
			break;
		case 24:
			printf("Spurious Interrupt -- PC = %#08X\n", \
				MCF5200_SF_PC(framep));
			break;
		case 25:
		case 26:
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
			printf("Autovector interrupt level %d\n",
				MCF5200_RD_SF_VECTOR(framep) - 24);
			break;
		case 32:
		case 33:
		case 34:
		case 35:
		case 36:
		case 37:
		case 38:
		case 39:
		case 40:
		case 41:
		case 42:
		case 43:
		case 44:
		case 45:
		case 46:
		case 47:
			printf("TRAP #%d\n", MCF5200_RD_SF_VECTOR(framep) - 32);
			break;
		case 5:
		case 6:
		case 7:
		case 13:
		case 16:
		case 17:
		case 18:
		case 19:
		case 20:
		case 21:
		case 22:
		case 23:
		case 48:
		case 49:
		case 50:
		case 51:
		case 52:
		case 53:
		case 54:
		case 55:
		case 56:
		case 57:
		case 58:
		case 59:
		case 60:
		case 61:
		case 62:
		case 63:
			printf("Reserved: #%d\n",
				MCF5200_RD_SF_VECTOR(framep));
			break;
		default:
			printf("User Defined Vector #%d\n",
				MCF5200_RD_SF_VECTOR(framep));
			break;
	}
}
/********************************************************************/

__interrupt__
void irq_handler (void) 
{
	printf("irq_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void user_spurious_handler (void) 
{
	printf("user_spurious_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq1_handler (void) 
{
	printf("ext_irq1_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq2_handler (void) 
{
	printf("ext_irq2_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq3_handler (void) 
{
	printf("ext_irq3_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq4_handler (void) 
{
	printf("ext_irq4_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void timer0_handler (void) 
{
	printf("timer0_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void timer1_handler (void) 
{
	printf("timer1_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void timer2_handler (void) 
{
	printf("timer2_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void timer3_handler (void) 
{
	printf("timer3_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void uart0_handler (void) 
{
	printf("uart0_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void uart1_handler (void) 
{
	printf("uart1_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void pli_periodic_handler (void) 
{
	printf("pli_periodic_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void pli_asynchronous_handler (void) 
{
	printf("pli_asynchronous_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint0_handler (void) 
{
	printf("usb_endpoint0_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint1_handler (void) 
{
	printf("usb_endpoint1_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint2_handler (void) 
{
	printf("usb_endpoint2_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint3_handler (void) 
{
	printf("usb_endpoint3_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint4_handler (void) 
{
	printf("usb_endpoint4_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint5_handler (void) 
{
	printf("usb_endpoint5_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint6_handler (void) 
{
	printf("usb_endpoint6_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void usb_endpoint7_handler (void) 
{
	printf("usb_endpoint7_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void dma_controller_handler (void) 
{
	printf("dma_controller_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ethernet_rx_handler (void) 
{
	printf("ethernet_rx_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ethernet_tx_handler (void) 
{
	printf("ethernet_tx_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ethernet_handler (void) 
{
	printf("ethernet_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void qspi_handler (void) 
{
	printf("qspi_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq5_handler (void) 
{
	printf("ext_irq5_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void ext_irq6_handler (void) 
{
	printf("ext_irq6_handler\n");
	/* empty */
}
/********************************************************************/

__interrupt__
void watchdog_handler (void) 
{
	printf("watchdog_handler\n");
	/* empty */
}
/********************************************************************/
